#include <stdio.h>

void merge(int arr[], int l, int m, int r)
{
    int i, j, k;
    int n1 = m - l + 1;
    int n2 = r - m;

    int L[n1], R[n2];

    for (i = 0; i < n1; i++)
        L[i] = arr[l + i];
    for (j = 0; j < n2; j++)
        R[j] = arr[m + 1 + j];

    i = 0;
    j = 0;
    k = l;
    while (i < n1 && j < n2) {
        if (L[i] <= R[j]) {
            arr[k] = L[i];
            i++;
        }
        else {
            arr[k] = R[j];
            j++;
        }
        k++;
    }

    while (i < n1) {
        arr[k] = L[i];
        i++;
        k++;
    }

    while (j < n2) {
        arr[k] = R[j];
        j++;
        k++;
    }
}

void mergeSort(int arr[], int l, int r)
{
    if (l < r) {
        int m = l + (r - l) / 2;

        mergeSort(arr, l, m);
        mergeSort(arr, m + 1, r);

        merge(arr, l, m, r);
    }
}

int notFound;

int binarySearch(int arr[], int l, int r, int x, int med)
{
    if (r >= l) {
        int mid = l + (r - l) / 2;

        if (arr[mid] == x)
            return mid;

        if (arr[mid] > x)
            return binarySearch(arr, l, mid - 1, x, med);

        return binarySearch(arr, mid + 1, r, x, med);
    }

    notFound = 1;
    if (x > med)
        return r;
    else
        return l;
}

int main() {
    int n, q;
    scanf("%d %d", &n, &q);
    int a[n], b[q], dist[2*n+1];
    for (int i = 0; i < n; i++) {
        scanf("%d", &a[i]);
    }
    for (int i = 0; i < q; i++) {
        scanf("%d", &b[i]);
    }

    mergeSort(a, 0, n - 1);

    int sredina = n/2;
    dist[sredina*2+1] = 0;
    dist[sredina*2] = n%2;
    dist[sredina*2+2] = 1 - n%2;
    int curDist = 0;
    for (int i = n/2 - 1; i >= 0; i--) {
        curDist++;
        if (a[i] == a[i+1]) {
            dist[i*2+1] = dist[(i+1)*2+1];
        } else {
            dist[i*2+1] = curDist;
        }
        dist[i*2] = dist[i*2+2] + 1;
    }
    curDist = 0;
    for (int i = n/2 + 1; i < n; i++) {
        curDist++;
        if (a[i] == a[i-1]) {
            dist[i*2+1] = dist[(i-1)*2+1];
        } else {
            dist[i*2+1] = curDist;
        }
        dist[i*2+2] = dist[i*2] + 1;
    }

    for (int i = 0; i < q; i++) {
        notFound = 0;
        int pos = binarySearch(a, 0, n-1, b[i], a[n/2]);
        int diff = dist[pos*2+1] * 2;
        if (notFound) {
            if (b[i] < a[n/2]) {
                diff = dist[pos * 2] * 2 + 1;
            } else {
                diff = dist[pos * 2 + 2] * 2 + 1;
            }
        }
        if ((n + notFound) % 2 == 1) {
            if (b[i] > a[n / 2]) diff--;
        } else {
            if (b[i] < a[n / 2]) diff--;
        }
        printf("%d\n", diff);
    }

    return 0;
}